<!DOCTYPE html>

<html lang="{{ config('app.locale') }}" dir={{(App::isLocale('en'))?"ltr":"rtl"}} direction="{{(App::isLocale('en'))?'ltr':'rtl'}}" style="direction:{{(App::isLocale('en'))?'ltr':'rtl'}};">

<style type="text/css">

</style>

@yield('styles')
<!-- BEGIN HEAD -->
@include('layouts.admin.includes')

<!-- END HEAD -->
<!-- Scripts -->
<?php
$setting = getUserSetting();
$setting = json_decode($setting);
?>


@if($setting->sidebar_type =="collapse")

<body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white page-sidebar-closed">
    @else

    <body class="page-header-fixed page-sidebar-closed-hide-logo page-content-white">
        @endif
        <div class="page-wrapper">
            <!-- BEGIN HEADER -->
            @include('layouts.admin.header')
            <!-- END HEADER -->
            <!-- BEGIN HEADER & CONTENT DIVIDER -->
            <div class="clearfix"></div>

            <!-- END HEADER & CONTENT DIVIDER -->
            <!-- BEGIN CONTAINER -->
            <div class="page-container">
                <!-- BEGIN SIDEBAR -->
                @include('layouts.admin.sidebar')
                <!-- END SIDEBAR -->
                <!-- BEGIN CONTENT -->
                <div class="page-content-wrapper">

                    <div class="page-content">
                        <!-- BEGIN SAMPLE PORTLET CONFIGURATION MODAL FORM-->
                        @if (Session('error'))

                        <div class="m-heading-1 border-red m-bordered errors-action">

                            <!--  <h4 class="error-title"><strong>Whoops!</strong></h4> -->
                            <ul class="error-body">

                                <li>{{ Session('error') }}</li>

                            </ul>

                        </div>

                        @endif

                        @if (Session('warning'))

                        <div class="m-heading-1 border-yellow m-bordered warning-action">

                            <!--  <h4 class="error-title"><strong>Whoops!</strong></h4> -->
                            <div class="warning-body">

                                <p style="font-weight: bold; font-size:20px;color:red">@lang('message.Warning')</p>
                                <p style="font-weight: bold; font-size:16px;">{{ Session('warning') }}</p>


                            </div>

                        </div>

                        @endif


                        @if (Session('message'))

                        <div class="m-heading-1 border-green m-bordered success-action">


                            <ul class="success-body">

                                <li>{{ Session('message') }}</li>

                            </ul>

                        </div>

                        @endif

                        @if (count($errors) > 0)

                        <div class="m-heading-1 border-red m-bordered errors-action">

                            <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your
                                input</h4>
                            <ul class="error-body">
                                @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                                @endforeach
                            </ul>

                        </div>

                        @endif


                        @yield('content')

                        <div class="block-event-div">
                            <div class="block-event-loader">
                                <img src="{{asset('ltr/assets/layouts/layout/img/ajax-modal-loading.gif')}}" />
                            </div>
                        </div>

                        <!-- END PAGE CONTENT-->
                    </div>
                </div>
                <!-- END CONTENT -->
                <!-- END CONTENT -->
                <!-- BEGIN QUICK SIDEBAR -->
                @include('layouts.admin.quickSidebar')
                <!-- END QUICK SIDEBAR -->
            </div>
            <!-- END CONTAINER -->
            <!-- BEGIN FOOTER -->
            @include('layouts.admin.footer')

            <!-- END FOOTER -->


        </div>


        @if(App::isLocale('fa'))
        <!-- 
        <script src="{{url('/vuejs/vee_validate_locale/fa.js')}}"></script>
        <script src="{{url('/vuejs/vee_validate_locale/pa.js')}}"></script> -->
        @elseif(App::isLocale('en'))
        <!-- <script src="{{url('/vuejs/vee_validate_locale/en.js')}}"></script> -->
        @endif

        <script src="{{url('/assets/bootstrap-fileinput/bootstrap-fileinput.js')}}" type="text/javascript"></script>
        <script src="{{url('/assets/bootstrap-fileinput/jquery.sparkline.min.js')}}" type="text/javascript"></script>


        <script>
            
            /** date picker for vuejs */
            Vue.component('date_picker', {
                template: '<input class="form-control" autocomplete="off" />',
                mounted: function() {
                    $(this.$el).persianDatepicker({
                        initialValue: false,
                        observer: true,
                        format: 'YYYY/MM/DD',
                        autoClose: true,
                        response: true,
                        initialValueType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
                        calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
                        calendar: {
                            persian: {
                                locale: 'en'
                            }
                        }
                    });
                }
            })

            /** date picker for vuejs end */

            var path = window.location.pathname;
            var path1 = "/CAS/public/" + window.location.pathname.split('/CAS/public/')[1];

            path = path.trim();
            path1 = path1.trim();

            if (path.split('/').length > 1 && path != '/') {

                if (path1 == path) {
                    path = "/CAS/public/" + path.split('/CAS/public/')[1];
                } else {
                    path = "/" + path.split('/')[1];
                }

                var newURL = window.location.protocol + "//" + window.location.host + path;

                $(" #sidebar-menu a[href~='" + newURL + "']").parent().addClass('active')
                $(" #sidebar-menu a[href~='" + newURL + "']").parent().parent().parent().addClass('active open')

                $(" #head-menu a[href~='" + newURL + "']").parent().addClass('active')
                $(" #head-menu a[href~='" + newURL + "']").parent().parent().parent().addClass('active selected')

            } else {

                var url = window.location.protocol + "//" + window.location.host;
                $(" #sidebar-menu a[href='" + url + "']").parent().addClass('active')
            }


            $('.errors-action').each(function() {
                // $('#error-sound')[0].play();
                toastr.error($(this).find('.error-body').html(), $(this).find('.error-title').html());

            });

            $('.success-action').each(function() {

                // $('#success-sound')[0].play();
                toastr.success($(this).find('.success-body').html(), $(this).find('.success-title').html());

            });
            $('.warning-action').each(function() {

                // $('#warning-sound')[0].play();
                toastr.warning($(this).find('.warning-body').html(), $(this).find('.warning-title').html());

            });

            $('.errors-action,.success-action,.warning-action').fadeOut(4000, 'swing', function() {

                $(this).remove();
            });
            @if(App::isLocale('en'))
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "positionClass": "toast-top-right",
                "onclick": null,
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }

            @else
            toastr.options = {
                "closeButton": true,
                "debug": false,
                "positionClass": "toast-top-left",
                "onclick": null,
                "hideDuration": "1000",
                "timeOut": "5000",
                "extendedTimeOut": "1000",
                "showEasing": "swing",
                "hideEasing": "linear",
                "showMethod": "fadeIn",
                "hideMethod": "fadeOut"
            }
            @endif
            $.extend(true, $.fn.dataTable.defaults, {
                "language": {
                    url: '{{(App::isLocale("fa") || App::isLocale("pa"))?url("/lang/fa/datatables.json"):url("/lang/en/datatables.json")}}'
                },
            });

            $(document).ready(function() {

                // console.log('wobj',window);
                // onChromeCLosed();


                var calendarType = 'gregorian';
                var initialValueType = 'gregorian';
                @if(App::isLocale('fa') || App::isLocale('pa'))
                calendarType = 'persian';
                initialValueType = 'persian';
                @endif
                // console.log('myloca','{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}');

                date = $(".date").persianDatepicker({
                    initialValue: false,
                    observer: true,
                    // autocomplete: true,
                    format: 'YYYY/MM/DD',
                    autoClose: true,
                    response: true,
                    initialValueType: initialValueType,

                    calendarType: '{{(App::isLocale("fa") || App::isLocale("pa"))?"persian":"gregorian"}}',
                    calendar: {
                        persian: {
                            locale: 'en'
                        }
                    }


                });
                

            });



            function myRound(amount = null) {
                var result = 0;

                if (amount != null) {
                    result = Number.parseFloat(amount).toFixed(precision());
                }
                return result;
            }

        </script>
        <!-- END THEME LAYOUT SCRIPTS -->
        @stack('scripts')

        <!-- BEGIN THEME LAYOUT SCRIPTS -->
        <!-- END THEME LAYOUT SCRIPTS -->


        <?php
        if (session()->has('days')) {
            $days = session()->get('days');
            echo '<script>alert("You have only ' . $days . ' days to expire the System");</script>';
            session()->forget('days');
        }
        if (session()->has('month')) {
            $month = session()->get('month');
            echo '<script>alert("Your System is expire after ' . $month . ' days");</script>';
            session()->forget('month');
        }
        ?>
    </body>

</html>